#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.VAL.UnitTests
{
	[TestFixture]
	public class VAL_LabOrder : BaseTest 
	{
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			VistALinkUnitTestHarness.RequireConnection();
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection(); 
		}

		[Test]
		public void GetLabOrderNumberBySpecimenUID_Pass()
		{
			DataSet dsTest = DAL.VAL.LabOrder.GetLabOrderNumberBySpecimenUID("2932460003");

			Assert.IsTrue(dsTest.Tables.Count > 0);
			Assert.IsTrue(dsTest.Tables[0].Rows.Count > 0);
			Assert.IsTrue(dsTest.Tables[0].Columns.Count == 7);
		}

		[Test]
		[ExpectedException( typeof(ArgumentNullException) )]
		public void GetLabOrderNumberBySpecimenUID_Fail()
		{
			DAL.VAL.LabOrder.GetLabOrderNumberBySpecimenUID( null );
		}

		[Test]
		public void GetLabAccessionByLabOrderNumber_Pass()
		{
			DataSet dsTest = DAL.VAL.LabOrder.GetLabAccessionByLabOrderNumber( "7439" );
			
			Assert.IsTrue(dsTest.Tables.Count > 0);
			Assert.IsTrue(dsTest.Tables[0].Rows.Count > 0);
			Assert.IsTrue(dsTest.Tables[0].Columns.Count == 1);
		}

		[Test]
		[ExpectedException( typeof(ArgumentNullException) )]
		public void GetLabAccessionByLabOrderNumber_Fail()
		{
			DAL.VAL.LabOrder.GetLabAccessionByLabOrderNumber( null );
		}
	}
}
#endif
